#include <iostream>
#include <fstream>
#include <string>
#include "logic.h"

using std::cout, std::endl, std::ifstream, std::string;

/**
 * TODO: Student implement this function
 * Load representation of the dungeon level from file into the 2D map.
 * Calls createMap to allocate the 2D array.
 * @param   fileName    File name of dungeon level.
 * @param   maxRow      Number of rows in the dungeon table (aka height).
 * @param   maxCol      Number of columns in the dungeon table (aka width).
 * @param   player      Player object by reference to set starting position.
 * @return  pointer to 2D dynamic array representation of dungeon map with player's location., or nullptr if loading fails for any reason
 * @updates  maxRow, maxCol, player
 */
char** loadLevel(const string& fileName, int& maxRow, int& maxCol, Player& player) {
    ifstream fin;
    //check if you have an exit
    fin.open(fileName);
    if (!fin.is_open() || fin.bad() || fin.eof() || fin.fail()) {
        return nullptr;
    }
    fin >> maxRow;
    if (fin.fail() || fin.bad()) {
        return nullptr;
    }
    fin >> maxCol;
    if (fin.fail() || fin.bad()) {
        return nullptr;
    }
    fin >> player.row ;
    if (fin.fail() || fin.bad()) {
        return nullptr;
    }
    fin >> player.col;
    if (fin.fail() || fin.bad()) {
        return nullptr;
    }
    
    if (maxRow < 1 || maxCol < 1 || player.row >= maxRow || player.col >= maxCol || player.row < 0 || player.col < 0) {
        return nullptr;
    }

    if (maxRow > INT32_MAX/maxCol) {
        return nullptr;
    }
    
    
    char** map = new char*[maxRow];
    for (int i = 0; i < maxRow; ++i) {
        map[i] = new char[maxCol];
    }

    for (int i = 0; i < maxRow; ++i){
        for (int j = 0; j < maxCol; ++j) {
            if (fin.eof() && fin.fail()) {
                return nullptr;
            }
            fin >> map[i][j];
            switch(map[i][j]) {
                case '-':
                case '+':
                case '$':
                case '@':
                case 'M':
                case '?':
                case '!':
                    break;
                default:
                    return nullptr;
            }
            if (fin.fail() || fin.bad()) {
                return nullptr;
            }
        }
    }
    bool no_exit = true;
    for (int i = 0; i < maxRow; ++i){
        for (int j = 0; j < maxCol; ++j) {
            if (map[i][j] == '?') {
                no_exit = false;
            }
            if (map[i][j] == '!') {
                no_exit = false;
            }
        }
    }

    if (no_exit) {
        return nullptr;
    }

    string check = "";
    fin >> check;
    if (check.size() > 0) {
        return nullptr;
    } 

    if (maxRow > INT32_MAX/maxCol) {
        return nullptr;
    }

    map[player.row][player.col] = 'o'; 
    
    return map;
}

/**
 * TODO: Student implement this function
 * Translate the character direction input by the user into row or column change.
 * That is, updates the nextRow or nextCol according to the player's movement direction.
 * @param   input       Character input by the user which translates to a direction.
 * @param   nextRow     Player's next row on the dungeon map (up/down).
 * @param   nextCol     Player's next column on dungeon map (left/right).
 * @updates  nextRow, nextCol
 */
void getDirection(char input, int& nextRow, int& nextCol) {
    if (input == 'w') {
        nextRow -= 1;
    }
    else if (input == 'a') {
        nextCol -= 1;
    }
    else if (input == 's') {
        nextRow += 1;
    }
    else if (input == 'd') {
        nextCol += 1;
    } 
}

/**
 * TODO: [suggested] Student implement this function
 * Allocate the 2D map array.
 * Initialize each cell to TILE_OPEN.
 * @param   maxRow      Number of rows in the dungeon table (aka height).
 * @param   maxCol      Number of columns in the dungeon table (aka width).
 * @return  2D map array for the dungeon level, holds char type.
 */
char** createMap(int maxRow, int maxCol) {
    char** map = new char*[maxRow];
    for (int i = 0; i < maxRow; ++i) {
        map[i] = new char[maxCol];
    }

    for (int i = 0; i < maxRow; ++i){
        for (int j = 0; j < maxCol; ++j) {
            map[i][j] = '-';
        }
    } 
    return map;
}

/**
 * TODO: Student implement this function
 * Deallocates the 2D map array.
 * @param   map         Dungeon map.
 * @param   maxRow      Number of rows in the dungeon table (aka height).
 * @return None
 * @update map, maxRow
 */
void deleteMap(char**& map, int& maxRow) {
    if (map != nullptr && maxRow > 0) {
        for(int i = 0; i < maxRow; ++i) {
            delete[] map[i];
        }
        delete[] map;
        maxRow = 0;
        map = nullptr; 
    } 
    else {
        map = nullptr;
        maxRow = 0;
    }
}

/**
 * TODO: Student implement this function
 * Resize the 2D map by doubling both dimensions.
 * Copy the current map contents to the right, diagonal down, and below.
 * Do not duplicate the player, and remember to avoid memory leaks!
 * You can use the STATUS constants defined in logic.h to help!
 * @param   map         Dungeon map.
 * @param   maxRow      Number of rows in the dungeon table (aka height), to be doubled.
 * @param   maxCol      Number of columns in the dungeon table (aka width), to be doubled.
 * @return  pointer to a dynamically-allocated 2D array (map) that has twice as many columns and rows in size.
 * @update maxRow, maxCol
 */
char** resizeMap(char** map, int& maxRow, int& maxCol) {
    if (map == nullptr || maxRow <= 0 || maxCol <= 0) {
        return nullptr;
    }
    int row = maxRow;
    char** newmap = new char*[maxRow * 2];
    for (int i = 0; i < (maxRow*2); ++i) {
        newmap[i] = new char[maxCol * 2];
    }

    for (int i = 0; i < maxRow; ++i) {
        for (int j = 0; j < maxCol; ++j) {
            for (int k = 0; k < 2; ++k) {
                for (int l = 0; l < 2; ++l) {
                    if ((map[i][j] == 'o') && (k == 1 || l == 1)) {
                        newmap[i+(k*maxRow)][j+(l*maxCol)] = '-';
                    }
                    else {
                        newmap[i+(k*maxRow)][j+(l*maxCol)] = map[i][j];
                    }
                }
            }
        }
    }
    maxRow = maxRow * 2;
    maxCol = maxCol * 2;
    deleteMap(map, row);
    return newmap;
}

/**
 * TODO: Student implement this function
 * Checks if the player can move in the specified direction and performs the move if so.
 * Cannot move out of bounds or onto TILE_PILLAR or TILE_MONSTER.
 * Cannot move onto TILE_EXIT without at least one treasure. 
 * If TILE_TREASURE, increment treasure by 1.
 * Remember to update the map tile that the player moves onto and return the appropriate status.
 * You can use the STATUS constants defined in logic.h to help!
 * @param   map         Dungeon map.
 * @param   maxRow      Number of rows in the dungeon table (aka height).
 * @param   maxCol      Number of columns in the dungeon table (aka width).
 * @param   player      Player object to by reference to see current location.
 * @param   nextRow     Player's next row on the dungeon map (up/down).
 * @param   nextCol     Player's next column on dungeon map (left/right).
 * @return  Player's movement status after updating player's position.
 * @update map contents, player
 */
int doPlayerMove(char** map, int maxRow, int maxCol, Player& player, int nextRow, int nextCol) {
    if (nextRow >= maxRow || nextCol >= maxCol || nextRow < 0 || nextCol < 0) {
        return 0;
    }
    int status = 0;
    char tile = map[nextRow][nextCol];
    switch(tile){
        case '+':
        case 'M':
            status = 0;
            break;
        case '$':
            player.treasure += 1;
            status = 2;
            break;
        case '-':
        case ' ':
            status = 1;
            break;
        case '@':
            status = 3;
            break;
        case '?':
            status = 4;
            break;
        case '!':
            if (player.treasure > 0) {
                status = 5;
            }
            else {
                status = 0;
            }
            break;
        default:
            status = 0;
    }
    
    if (status != 0) {
        map[nextRow][nextCol] = 'o';
        map[player.row][player.col] = '-';
        player.row = nextRow;
        player.col = nextCol;
    } 

    return status;
}

/**
 * TODO: Student implement this function
 * Update monster locations:
 * We check up, down, left, right from the current player position.
 * If we see an obstacle, there is no line of sight in that direction, and the monster does not move.
 * If we see a monster before an obstacle, the monster moves one tile toward the player.
 * We should update the map as the monster moves.
 * At the end, we check if a monster has moved onto the player's tile.
 * @param   map         Dungeon map.
 * @param   maxRow      Number of rows in the dungeon table (aka height).
 * @param   maxCol      Number of columns in the dungeon table (aka width).
 * @param   player      Player object by reference for current location.
 * @return  Boolean value indicating player status: true if monster reaches the player, false if not.
 * @update map contents
 */
bool doMonsterAttack(char** map, int maxRow, int maxCol, const Player& player) {
    for (int i = (player.row - 1); i >= 0; --i) {
        if (map[i][player.col] == 'M') {
            map[i][player.col] = '-';
            map[i+1][player.col] = 'M';
        }
        else if (map[i][player.col] == '+')
        {
            break;
        }   
    }

    for (int i = (player.row + 1); i < maxRow; ++i) {
        if (map[i][player.col] == 'M') {
            map[i][player.col] = '-';
            map[i-1][player.col] = 'M';
        }
        else if (map[i][player.col] == '+')
        {
            break;
        }   
    }    

    for (int i = (player.col - 1); i >= 0; --i) {
        if (map[player.row][i] == 'M') {
            map[player.row][i] = '-';
            map[player.row][i+1] = 'M';
        }
        else if (map[player.row][i] == '+')
        {
            break;
        }   
    } 

    for (int i = (player.col + 1); i < maxCol; ++i) {
        if (map[player.row][i] == 'M') {
            map[player.row][i] = '-';
            map[player.row][i-1] = 'M';
        }
        else if (map[player.row][i] == '+')
        {
            break;
        }   
    } 


    if (map[player.row][player.col] == 'M') {
        return true;
    }
    else {
        return false;
    } 
}
