#include <iostream>
#include <fstream>
#include <string>
#include <sstream>
using std::ofstream, std::endl, std::string, std::to_string, std::ifstream;

int main() {
    ofstream fout("output.smt2");
    ifstream fin("input.txt");
    int val;

    // Declare variables
    for(int i = 1; i <= 9; ++i) {
        for(int j = 1; j <= 9; ++j) {
            for(int k = 1; k <= 9; ++k) {
                fout << "(declare-const P_" << j << "_" << i << "_" << k << " Bool)" << endl; 
            }
        }
    }

    //Get the input variables
    for(int j = 1; j <= 9; ++j) {
        for(int i = 1; i <= 9; ++i) {
                fin >> val;
                if (val > 0) {
                    fout << "(assert P_" << j << "_" << i << "_" << val << ")" << endl; 
                }
        }
    }

    //Assert rules for rows
    for(int i = 1; i <= 9; ++i) {
        for(int k = 1; k <= 9; ++k) {
            fout << "(assert (or ";
            for(int j = 1; j <= 9; ++j) {
                fout << "P_" << j << "_" << i << "_" << k << " ";
            }
            fout << "))" << endl;
        }
    }

    //Assert rules for columns
    for(int j = 1; j <= 9; ++j) {
        for(int k = 1; k <= 9; ++k) {
            fout << "(assert (or ";
            for(int i = 1; i <= 9; ++i) {
                fout << "P_" << j << "_" << i << "_" << k << " ";
            }
            fout << "))" << endl;
        }
    }

    //Assert rules for Blocks
    for (int mult_i = 0; mult_i <= 2; ++mult_i) {
        for (int mult_j = 0; mult_j <= 2; ++mult_j) {
            for(int k = 1; k <= 9; ++k) {
                fout << "(assert (or ";
                for(int i = 1; i <= 3; ++i) {
                    for(int j = 1; j <= 3; ++j) {
                        fout << "P_" << j + (mult_j * 3) << "_" << i + (mult_i * 3) << "_" << k << " ";
                    }
                }
                fout << "))" << endl;
            }
        }
    }

    //Assert that only one number appears in each cell
    for(int k = 1; k <= 9; ++k) {
        for (int i = 1; i <= 9; ++i) {
            for (int j = 1; j <= 9; ++j) {
                fout << "(assert (or (not P_" << j << "_" << i << "_" << k << ") (not (or ";
                for(int k0 = 1; k0 <= 9; ++k0) {
                    if (k0 != k) {
                        fout << "P_" << j << "_" << i << "_" << k0 << " ";
                    }
                }
                fout << "))))" << endl;
            }
        }
    }

    fout << "(check-sat)" << endl;
    fout << "(get-model)" << endl;
}